(function ($, root, undefined) {

	$(function () {

		'use strict';

		// DOM ready, take it away

		// Hamburger
		var $hamburger = $(".hamburger");
		$hamburger.on("click", function() {
		  $hamburger.toggleClass("is-active");

			$('.mobile-nav').animate({width:'toggle'},200);
			$('.menu-mask').fadeToggle(300);

			if ($(document).height() > $(window).height()) {
			   var scrollTop = ($('html').scrollTop()) ? $('html').scrollTop() : $('body').scrollTop(); // Works for Chrome, Firefox, IE...
			   $('html').toggleClass('noscroll').css('top',-scrollTop);
			}

		});

		// Function: Check if window scrolled
		function windowScrolled() {
			if($(window).scrollTop() > 30) { //abuse 0 == false :)
			  $('.header').addClass('scrolled');
			}
			else {
				$('.header').removeClass('scrolled');
			}
		}

		// // On page load
		// $(window).load(function() {
		// 	windowScrolled();
		// });

		// On window resize
		$(window).resize(function() {
			windowScrolled();
		});

		// On window scroll
		$(window).scroll(function(){
			windowScrolled();
		});

		// Sliders
		$('.product-slider .slider').flickity({
			cellAlign: 'left',
			contain: true,
			freeScroll: false,
			prevNextButtons: false,
			pageDots: true,
			wrapAround: true,
			autoPlay: 8000,
		});

		// Home slider
		/*
		$('.home-slider .slide').first().addClass('active');
		$('.parallax-mirror').hide().fadeIn(900);

		$('.home-slider .slide').click(function(){
			$(this).removeClass('active').hide();

			if($(this).is(':last-child')) {
				$('.home-slider').find('.slide[slide-number="1"]').addClass('active').fadeIn();
			}
			else {
				$(this).next('.slide').addClass('active').fadeIn();
			}
		  $(window).trigger('resize');
			$('.parallax-mirror').hide().fadeIn(900);

		});
		*/

 		// Projects animation
		$('.highlighted-projects .col-md-4').mouseenter(function(){
			$('.highlighted-projects .col-md-4').removeClass('col-md-4').addClass('col-md-2');
			$(this).addClass('col-md-8');
		}).mouseleave(function(){
			$('.highlighted-projects .col-md-2').removeClass('col-md-2').addClass('col-md-4');
			$(this).removeClass('col-md-8');
		});

		// Check scroll and scroll direction
		var lastScrollTop = 0;
		$(window).scroll(function () {
			var scrollTop = $(this).scrollTop();

			if ($(this).scrollTop() > 10) {
				if (scrollTop > lastScrollTop){
					$('.header').removeClass('white');
					// $('.header').addClass('black');
				}
				else {
					$('.header').addClass('white');
					if ($('.header').hasClass('transparent')) {
						$('.header').addClass('black');
					}
				}
			}
			else {
				// no sroll
				$('.header').removeClass('white');
				$('.header').removeClass('black');
			}
			lastScrollTop = scrollTop;

		});

		// Custom order contact form columns
		$('#gform_wrapper_2 ul').wrapInner('<div class="row"></div>');
		$('#gform_wrapper_2 ul .row > li:lt(4)').wrapAll('<div class="col-xs-12 col-md-4"></div>');
		$('#gform_wrapper_2 ul .row > li:nth-child(2)').wrapAll('<div class="col-xs-12 col-md-6"></div>');
		$('#gform_wrapper_2 ul .row').prepend('<div class="col-xs-12 col-md-1"></div>');
		$('#gform_wrapper_2 ul .gform_footer').wrapInner('<div class="row"></div>');

		// Instructions accordion
		$('.instructions-list .title').click(function() {
			var content = $(this).next('.content');
			$(content).slideToggle(300);
			$('.instructions-list .content').not(content).slideUp(300);
			$(this).toggleClass('active');
			$('.instructions-list .title').not(this).removeClass('active');
		});

		// Product info accordion
		$('.information .info .title').click(function() {
			var content = $(this).next('.description');
			$(content).slideToggle(300);
			$('.description').not(content).slideUp(300);
			$(this).toggleClass('active');
			$('.information .info .title').not(this).removeClass('active');
		});

		// Get var from url
		var getUrlParameter = function getUrlParameter(sParam) {
		    var sPageURL = decodeURIComponent(window.location.search.substring(1)),
			sURLVariables = sPageURL.split('&'),
			sParameterName,
			i;

		    for (i = 0; i < sURLVariables.length; i++) {
			sParameterName = sURLVariables[i].split('=');

			if (sParameterName[0] === sParam) {
			    return sParameterName[1] === undefined ? true : sParameterName[1];
			}
		    }
		};

		// Scroll to project
		var project = getUrlParameter('project');
		if (project > '') {
			$('html, body').animate({
			    scrollTop: $('#'+project).offset().top
			}, 2000);
			ScrollReveal().reveal('.reveal', slideUp);
			return false;
		}

		// Scroll to samples
		var samples = getUrlParameter('samples');
		if (samples > '') {
			$('html, body').animate({
					scrollTop: $('#samples').offset().top
			}, 2000);
		}

		// Lazy load
		/*
		$('.lazy').lazy({
			effect: "fadeIn",
			effectTime: 2000,
		});

		$('.lazy-youtube').lazy({
			effect: "fadeIn",
			afterLoad: function(element) {
				// called after an element was successfully handled
				$(element).addClass('show');
			},
		});
		*/

		// Scroll reveal
		var slideUp = {
			duration: 1200,
	    distance: '48px',
	    origin: 'bottom',
	    opacity: 0.1,
		};

		// Scroll reveal
		ScrollReveal().reveal('.reveal', slideUp);

		var slideUp = {
			duration: 1200,
			distance: '96px',
			origin: 'bottom',
			opacity: 0.1,
		};

		// Scroll reveal
		ScrollReveal().reveal('.reveal-slower', slideUp);

		$(window).on("load", function () {
			if ($(window).scrollTop() > 0) {
				ScrollReveal().destroy();
			}
		});
		$(window).scroll(function() {
			$(".hero-image-page h1, .hero-slider .inner").css({
			'opacity' : 1-(($(this).scrollTop())/150)
			});
		});


		// Modal
		$('.header .mini-cart').click(function() {
			$('.cart-content').show();
			$('.mini-cart-content').fadeIn();
			if ($(document).height() > $(window).height()) {
				 var scrollTop = ($('html').scrollTop()) ? $('html').scrollTop() : $('body').scrollTop(); // Works for Chrome, Firefox, IE...
				 $('html').addClass('noscroll').css('top',-scrollTop);
			}
		});

		// open search modal
		$('.search').click(function(){
			$('.search-box').show();
			$('.modal-container').fadeIn();
			$('#search').focus();
			if ($(document).height() > $(window).height()) {
				 var scrollTop = ($('html').scrollTop()) ? $('html').scrollTop() : $('body').scrollTop(); // Works for Chrome, Firefox, IE...
				 $('html').addClass('noscroll').css('top',-scrollTop);
			}
		});

		// open subscribe modal
		$('#subscribe').click(function(){
			$('#newsletter-modal').show();
			$('.modal-container').fadeIn();
		});

		// open quote modal
		$('#request-quote').click(function(){
			$('#request-quote-modal').show();
			$('.modal-container').fadeIn();
		});

		// close modal function
		function modal_close(){
			$("body").find(".modal").hide();
	    $('html').removeClass('noscroll');
	    $('.modal-container,.mini-cart-content').hide();
	    $('#search').val('');
	    $('.search-results').empty();
		}
		// close modal
		$('.modal .close').click(function(){
			modal_close();
		});
		$('.modal').click(function(event) {
			//if you click on anything except the modal itself or the "open modal" link, close the modal
			if (!$(event.target).closest(".content,.mini-cart-content").length) {
				modal_close();
			}
		});

		// shop filter
		// $('.product-filter ul li').click(function() {
		//
		// 	var category = $(this).attr('rel');
		//
		// 	$('.product-filter ul li').removeClass('active');
		// 	$(this).addClass('active');
		//
		// 	$('.products .item').hide();
		// 	$('.'+category).fadeIn().removeClass('reveal');
		//
		// });

		$('.category-select select').change(function() {
			var category = $(this).children("option:selected").attr('rel');
			window.location.href = category;
		});

	});

})(jQuery, this);
